/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;

public class ptzoom
extends Applet
implements Runnable {
    String PTViewer = "ptviewer";
    ptviewer pv = null;
    Thread loadImages = null;
    String filename = "image";
    String maskname = null;
    int width;
    int height;
    ImageData idata = null;
    byte[][] hsdata = null;
    private double[][] mt;
    private double[][] md;
    double cpitch = 0.0;
    double cyaw = 0.0;
    double croll = 0.0;
    double chfov = 50.0;
    int showSHS = -1;
    boolean progress = false;
    Image zoom_image = null;
    String hsimage = null;
    boolean ready = false;
    double max_oversampling = 8.0;
    int position = 0;
    public double exposure = 1.0;
    double gamma = 1.4;
    boolean antialias = false;
    Vector scaledImages = null;
    Vector scaledHSImages = null;
    boolean single = false;

    public ptzoom() {
    }

    public ptzoom(ptviewer ptviewer2, String string) {
        this.pv = ptviewer2;
        this.setStub(new ptstub(this.pv, string));
    }

    public ptzoom(ptviewer ptviewer2, Image image, byte[] byArray, String string) {
        this.pv = ptviewer2;
        this.zoom_image = image;
        if (byArray != null && byArray.length == image.getWidth(null) * image.getHeight(null)) {
            this.hsdata = new byte[image.getHeight(null)][image.getWidth(null)];
            int n = 0;
            while (n < image.getHeight(null)) {
                System.arraycopy(byArray, n * image.getWidth(null), this.hsdata[n], 0, image.getWidth(null));
                ++n;
            }
        }
        this.setStub(new ptstub(this.pv, string));
    }

    public ptzoom(ptviewer ptviewer2, int[][] nArray, double d, double d2, double d3, double d4) {
        this.pv = ptviewer2;
        this.chfov = d;
        this.cyaw = d2;
        this.cpitch = d3;
        this.croll = d4;
        this.width = nArray[0].length;
        this.height = nArray.length;
        this.hsdata = new byte[this.height][this.width];
        if (this.hsimage == null) {
            int n = 0;
            while (n < this.height) {
                int n2 = 0;
                while (n2 < this.width) {
                    this.hsdata[n][n2] = -1;
                    ++n2;
                }
                ++n;
            }
        }
        this.idata = new ImageData(nArray, this.pv);
        this.setStub(new ptstub(this.pv, ""));
        this.max_oversampling = 1000.0;
    }

    public void init() {
        this.mt = new double[3][3];
        this.md = new double[3][3];
        String string = this.getParameter("PTViewer");
        if (string != null) {
            this.PTViewer = string;
        }
        if ((string = this.getParameter("file")) != null) {
            this.filename = string;
        }
        if ((string = this.getParameter("mask")) != null) {
            this.maskname = string;
        }
        if ((string = this.getParameter("hsimage")) != null) {
            this.hsimage = string;
        }
        if ((string = this.getParameter("exposure")) != null) {
            this.exposure = Double.valueOf(string);
        }
        if ((string = this.getParameter("gamma")) != null) {
            this.gamma = Double.valueOf(string);
        }
        if ((string = this.getParameter("fov")) != null) {
            this.chfov = Double.valueOf(string);
        }
        if ((string = this.getParameter("pan")) != null) {
            this.cyaw = Double.valueOf(string);
        }
        if ((string = this.getParameter("tilt")) != null) {
            this.cpitch = Double.valueOf(string);
        }
        if ((string = this.getParameter("rot")) != null) {
            this.croll = Double.valueOf(string);
        }
        if ((string = this.getParameter("showSHS")) != null) {
            this.showSHS = Integer.parseInt(string);
        }
        if ((string = this.getParameter("progress")) != null && string.equalsIgnoreCase("true")) {
            this.progress = true;
        }
        if ((string = this.getParameter("antialias")) != null) {
            this.antialias = true;
            this.max_oversampling = 1.5;
        }
        if ((string = this.getParameter("oversampling")) != null) {
            this.max_oversampling = Double.valueOf(string);
        }
        if ((string = this.getParameter("single")) != null) {
            this.single = true;
        }
    }

    public void start() {
        while (this.pv == null) {
            try {
                this.pv = (ptviewer)this.getAppletContext().getApplet(this.PTViewer);
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
        if (this.pv != null) {
            this.pv.startCommunicating(this);
            if (this.idata == null) {
                if (this.zoom_image == null) {
                    if (this.loadImages == null) {
                        this.loadImages = new Thread(this);
                        this.loadImages.start();
                    }
                } else {
                    this.load_zoom_image();
                }
            } else {
                this.SetDefMatrix();
                this.pv.dirty = true;
                this.pv.repaint();
                this.ready = true;
            }
        }
    }

    public synchronized void set(double d, double d2, double d3, double d4, int[][] nArray) {
        this.chfov = d;
        this.cyaw = d2;
        this.cpitch = d3;
        this.croll = d4;
        if (nArray != this.idata.data) {
            this.width = nArray[0].length;
            this.height = nArray.length;
            if (this.hsdata[0].length != this.width || this.hsdata.length != this.height) {
                this.hsdata = new byte[this.height][this.width];
                int n = 0;
                while (n < this.height) {
                    int n2 = 0;
                    while (n2 < this.width) {
                        this.hsdata[n][n2] = -1;
                        ++n2;
                    }
                    ++n;
                }
            }
            this.idata.data = nArray;
        }
        this.SetDefMatrix();
        this.pv.dirty = true;
        this.pv.repaint();
    }

    public void set(double d, double d2, double d3, double d4, int[][] nArray, int n) {
        this.position = n;
        this.set(d, d2, d3, d4, nArray);
    }

    public void stop() {
        if (this.pv != null) {
            if (this.loadImages != null) {
                this.pv.stopThread(this.loadImages);
                this.loadImages = null;
            }
            if (this.showSHS >= 0 && this.showSHS < this.pv.numshs) {
                this.pv.shs_imode[this.showSHS] = 0;
            }
            this.pv.stopCommunicating(this);
        }
        this.scaledImages = null;
        this.scaledHSImages = null;
    }

    public synchronized void setExposure(double d) {
        this.exposure = d;
    }

    public void run() {
        this.load_zoom_image();
    }

    void load_zoom_image() {
        Image image;
        this.idata = this.zoom_image == null ? new ImageData(this.filename, this.pv, this.progress, this.exposure, this.gamma) : new ImageData(this.zoom_image, this.pv);
        this.width = this.idata.width;
        this.height = this.idata.height;
        if (this.maskname != null && (image = this.pv.loadImage(this.maskname)) != null && image.getWidth(null) == this.width && image.getHeight(null) == this.height) {
            this.pv.ptImageToAlpha(this.idata.data, image);
            image = null;
        }
        if (this.hsdata == null) {
            this.hsdata = new byte[this.height][this.width];
            if (this.hsimage == null) {
                if (this.pv.filename != null && this.pv.filename.toLowerCase().endsWith(".mov")) {
                    int n = 0;
                    while (n < this.height) {
                        int n2 = 0;
                        while (n2 < this.width) {
                            this.hsdata[n][n2] = 0;
                            ++n2;
                        }
                        ++n;
                    }
                } else {
                    int n = 0;
                    while (n < this.height) {
                        int n3 = 0;
                        while (n3 < this.width) {
                            this.hsdata[n][n3] = -1;
                            ++n3;
                        }
                        ++n;
                    }
                }
            } else {
                image = this.pv.loadImage(this.hsimage);
                if (image != null && image.getWidth(null) == this.width && image.getHeight(null) == this.height) {
                    int[][] nArray = new int[this.height][this.width];
                    this.pv.ptImageTo2DArray(nArray, image);
                    int n = 0;
                    while (n < this.height) {
                        int n4 = 0;
                        while (n4 < this.width) {
                            this.hsdata[n][n4] = (byte)(nArray[n][n4] >> 24);
                            ++n4;
                        }
                        ++n;
                    }
                    nArray = null;
                    image = null;
                    System.gc();
                }
            }
        }
        this.SetDefMatrix();
        if (this.single) {
            double[] dArray;
            double d;
            this.pv.hfov_max = this.chfov;
            if (this.pv.hfov > this.chfov) {
                this.pv.hfov = this.chfov;
            }
            if (this.pv.yaw_max > this.chfov / 2.0) {
                this.pv.yaw_max = this.chfov / 2.0;
            }
            if (this.pv.yaw_min < -this.chfov / 2.0) {
                this.pv.yaw_min = -this.chfov / 2.0;
            }
            if (this.pv.pitch_max > (d = 90.0 - (dArray = this.pv.math_view2pano(0, 0, this.width, this.height, 360, 180, 0.0, 0.0, this.chfov))[1])) {
                this.pv.pitch_max = d;
            }
            if (this.pv.pitch_min < -d) {
                this.pv.pitch_min = -d;
            }
        }
        this.pv.dirty = true;
        if (this.showSHS >= 0 && this.showSHS < this.pv.numshs) {
            this.pv.shs_imode[this.showSHS] = 2;
        }
        if (this.progress) {
            this.pv.ready = true;
        }
        this.pv.repaint();
        this.ready = true;
    }

    public void paint(Graphics graphics) {
        ImageData imageData;
        if (this.pv == null || this.hsdata == null || this.idata == null || this.idata.data == null || this.pv.vdata == null) {
            return;
        }
        if (this.antialias && this.scaledImages == null) {
            this.scaledImages = new Vector();
            this.scaledImages.addElement(this.idata);
            imageData = this.idata;
            double d = this.pv.hfov_max / ((double)this.pv.vwidth * this.chfov * this.max_oversampling);
            int n = 0;
            while (imageData != null && (double)imageData.width * d > 1.0) {
                imageData = this.pv.im_halfsize(imageData);
                this.scaledImages.addElement(imageData);
                ++n;
            }
            this.scaledHSImages = new Vector();
            this.scaledHSImages.addElement(this.hsdata);
            byte[][] byArray = this.hsdata;
            while (byArray != null && (double)byArray[0].length * d > 1.0) {
                byArray = this.pv.hsim_halfsize(byArray);
                this.scaledHSImages.addElement(byArray);
            }
        }
        if (this.pv.dirty && (this.antialias || this.pv.hfov * (double)this.width < this.max_oversampling * this.chfov * (double)this.pv.vwidth)) {
            imageData = this.idata;
            byte[][] byArray = this.hsdata;
            if (this.antialias && this.scaledImages != null) {
                double d = this.pv.hfov / ((double)this.pv.vwidth * this.chfov * this.max_oversampling);
                int n = 0;
                int n2 = imageData.width;
                while ((double)n2 * d > 1.0) {
                    ++n;
                    n2 /= 2;
                }
                if (this.scaledImages.elementAt(n) != null) {
                    imageData = (ImageData)this.scaledImages.elementAt(n);
                    byArray = (byte[][])this.scaledHSImages.elementAt(n);
                }
            }
            switch (this.pv.quality) {
                case 0: {
                    this.pv.dirty = !this.SetView(imageData, byArray, false);
                    break;
                }
                case 1: {
                    if (this.pv.panning || this.pv.lastframe > this.pv.frames) {
                        this.SetView(imageData, byArray, false);
                        break;
                    }
                    this.pv.dirty = !this.SetView(imageData, byArray, true);
                    break;
                }
                case 2: {
                    if (this.pv.panning) {
                        this.SetView(imageData, byArray, false);
                        break;
                    }
                    this.pv.dirty = !this.SetView(imageData, byArray, true);
                    break;
                }
                case 3: {
                    this.pv.dirty = !this.SetView(imageData, byArray, true);
                }
            }
        }
    }

    boolean SetView(ImageData imageData, byte[][] byArray, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n7 = 0;
        boolean bl4 = true;
        double d = 0.0;
        this.SetMatrix(this.pv.pitch * 2.0 * Math.PI / 360.0, (this.pv.yaw - this.cyaw) * 2.0 * Math.PI / 360.0, 1);
        if (this.position == 1) {
            this.ShiftCubeFace(1.5707963267948966);
        } else if (this.position == 2) {
            this.ShiftCubeFace(-1.5707963267948966);
        } else if (this.position == 3) {
            this.TiltCubeFace(-1.5707963267948966);
        } else if (this.position == 4) {
            this.TiltCubeFace(1.5707963267948966);
        }
        double d2 = (double)this.pv.vwidth / (2.0 * Math.tan(this.pv.hfov * Math.PI / 180.0 / 2.0));
        double d3 = (double)imageData.width / (2.0 * Math.tan(this.chfov * Math.PI / 180.0 / 2.0));
        n5 = 0;
        while (n5 < 3) {
            double[] dArray = this.mt[2];
            int n8 = n5++;
            dArray[n8] = dArray[n8] * d2;
        }
        n5 = 0;
        while (n5 < 3) {
            n6 = 0;
            while (n6 < 2) {
                double[] dArray = this.mt[n5];
                int n9 = n6++;
                dArray[n9] = dArray[n9] * d3;
            }
            ++n5;
        }
        d = 256.0;
        while (d2 * d2 * d / 256.0 > 1.0E7) {
            d /= 2.0;
        }
        int n10 = (int)(d * this.mt[0][0] + 0.5);
        int n11 = (int)(d * this.mt[0][1] + 0.5);
        int n12 = (int)(d * this.mt[0][2] + 0.5);
        int n13 = (int)(d * this.mt[1][0] + 0.5);
        int n14 = (int)(d * this.mt[1][1] + 0.5);
        int n15 = (int)(d * this.mt[1][2] + 0.5);
        int n16 = (int)(d * this.mt[2][0] + 0.5);
        int n17 = (int)(d * this.mt[2][1] + 0.5);
        int n18 = (int)(d * this.mt[2][2] + 0.5);
        int n19 = (this.pv.vwidth - 1) / 2;
        int n20 = this.pv.vheight / 2;
        int n21 = imageData.width * 128 + 64;
        int n22 = imageData.height * 128 + 64;
        int n23 = imageData.height - 1;
        int n24 = imageData.width - 1;
        int n25 = 0;
        int n26 = 0;
        int n27 = 0;
        int n28 = 0;
        boolean bl5 = false;
        byte[] byArray2 = byArray[0];
        this.idata.setLut(this.exposure);
        if (bl) {
            n2 = 0;
            int n29 = -n20 * n15 + n18 + 128;
            int n30 = -n20 * n13 + n16;
            int n31 = -n20 * n14 + n17;
            while (n2 < this.pv.vheight) {
                n25 = this.pv.vwidth * n2;
                n = 0;
                n28 = n25;
                int n32 = -n19 * n12 + n29;
                int n33 = -n19 * n10 + n30;
                int n34 = -n19 * n11 + n31;
                while (n < this.pv.vwidth) {
                    if (this.pv.vdata[n28] == 0) {
                        n7 = (n32 + n * n12) / 256;
                        if (n7 <= 0) {
                            bl4 = false;
                        } else {
                            n3 = (n33 + n * n10) / n7 + n21;
                            n4 = (n34 + n * n11) / n7 + n22;
                            n26 = n3 & 0xFF;
                            n27 = n4 & 0xFF;
                            if ((n3 >>= 8) >= 0 && (n4 >>= 8) >= 0 && n4 < n23 && n3 < n24) {
                                int n35 = imageData.getPixel(n3, n4);
                                if ((n35 & 0xFF000000) != 0) {
                                    this.pv.hs_vdata[n28] = byArray[n4][n3];
                                    this.pv.vdata[n28] = imageData.getPixel(n3, n4, n26, n27);
                                } else {
                                    bl4 = false;
                                }
                            } else {
                                int n36;
                                if (n4 == -1) {
                                    n4 = 0;
                                } else if (n4 == imageData.height) {
                                    n4 = n23;
                                }
                                if (n3 == -1) {
                                    n3 = 0;
                                } else if (n3 == imageData.width) {
                                    n3 = n24;
                                }
                                if (n3 >= 0 && n3 < imageData.width && n4 >= 0 && n4 < imageData.height && ((n36 = imageData.getPixel(n3, n4)) & 0xFF000000) != 0) {
                                    this.pv.vdata[n28] = n36;
                                    this.pv.hs_vdata[n28] = byArray[n4][n3];
                                } else {
                                    bl4 = false;
                                }
                            }
                        }
                    }
                    ++n;
                    ++n28;
                }
                ++n2;
                n29 += n15;
                n30 += n13;
                n31 += n14;
            }
        } else {
            n21 += 128;
            n22 += 128;
            n2 = 0;
            int n37 = -n20 * n15 + n18 + 128;
            int n38 = -n20 * n13 + n16;
            int n39 = -n20 * n14 + n17;
            while (n2 < this.pv.vheight) {
                n25 = this.pv.vwidth * n2;
                n = 0;
                n28 = n25;
                int n40 = -n19 * n12 + n37;
                int n41 = -n19 * n10 + n38;
                int n42 = -n19 * n11 + n39;
                while (n < this.pv.vwidth) {
                    if (this.pv.vdata[n28] == 0) {
                        n7 = (n40 + n * n12) / 256;
                        if (n7 <= 0) {
                            bl4 = false;
                        } else {
                            int n43;
                            n3 = (n41 + n * n10) / n7 + n21 >> 8;
                            n4 = (n42 + n * n11) / n7 + n22 >> 8;
                            if (n3 >= 0 && n3 < imageData.width && n4 >= 0 && n4 < imageData.height && ((n43 = imageData.getPixel(n3, n4)) & 0xFF000000) != 0) {
                                this.pv.vdata[n28] = n43;
                            } else {
                                if (n3 == -1) {
                                    n3 = 0;
                                } else if (n3 == imageData.width) {
                                    n3 = n24;
                                }
                                if (n4 == -1) {
                                    n4 = 0;
                                } else if (n4 == imageData.height) {
                                    n4 = n23;
                                }
                                if (n3 >= 0 && n3 < imageData.width && n4 >= 0 && n4 < imageData.height && ((n43 = imageData.getPixel(n3, n4)) & 0xFF000000) != 0) {
                                    this.pv.vdata[n28] = n43;
                                } else {
                                    bl4 = false;
                                }
                            }
                        }
                    }
                    ++n;
                    ++n28;
                }
                ++n2;
                n37 += n15;
                n38 += n13;
                n39 += n14;
            }
        }
        return bl4;
    }

    void SetMatrix(double d, double d2, int n) {
        double[][] dArray = new double[3][3];
        double[][] dArray2 = new double[3][3];
        double[][] dArray3 = new double[3][3];
        dArray[0][0] = 1.0;
        dArray[0][1] = 0.0;
        dArray[0][2] = 0.0;
        dArray[1][0] = 0.0;
        dArray[1][1] = Math.cos(d);
        dArray[1][2] = Math.sin(d);
        dArray[2][0] = 0.0;
        dArray[2][1] = -dArray[1][2];
        dArray[2][2] = dArray[1][1];
        dArray2[0][0] = Math.cos(d2);
        dArray2[0][1] = 0.0;
        dArray2[0][2] = -Math.sin(d2);
        dArray2[1][0] = 0.0;
        dArray2[1][1] = 1.0;
        dArray2[1][2] = 0.0;
        dArray2[2][0] = -dArray2[0][2];
        dArray2[2][1] = 0.0;
        dArray2[2][2] = dArray2[0][0];
        if (n == 1) {
            this.pv.matrix_matrix_mult(dArray, dArray2, dArray3);
        } else {
            this.pv.matrix_matrix_mult(dArray2, dArray, dArray3);
        }
        this.pv.matrix_matrix_mult(dArray3, this.md, this.mt);
    }

    void SetDefMatrix() {
        double[][] dArray = new double[3][3];
        double[][] dArray2 = new double[3][3];
        double d = -this.cpitch * 2.0 * Math.PI / 360.0;
        double d2 = -this.croll * 2.0 * Math.PI / 360.0;
        dArray[0][0] = 1.0;
        dArray[0][1] = 0.0;
        dArray[0][2] = 0.0;
        dArray[1][0] = 0.0;
        dArray[1][1] = Math.cos(d);
        dArray[1][2] = Math.sin(d);
        dArray[2][0] = 0.0;
        dArray[2][1] = -dArray[1][2];
        dArray[2][2] = dArray[1][1];
        dArray2[0][0] = Math.cos(d2);
        dArray2[0][1] = Math.sin(d2);
        dArray2[0][2] = 0.0;
        dArray2[1][0] = -dArray2[0][1];
        dArray2[1][1] = dArray2[0][0];
        dArray2[1][2] = 0.0;
        dArray2[2][0] = 0.0;
        dArray2[2][1] = 0.0;
        dArray2[2][2] = 1.0;
        this.pv.matrix_matrix_mult(dArray, dArray2, this.md);
    }

    public String getAppletInfo() {
        return "topFrame";
    }

    void ShiftCubeFace(double d) {
        double[][] dArray = new double[3][3];
        double[][] dArray2 = new double[3][3];
        dArray2[0][0] = Math.cos(d);
        dArray2[0][1] = 0.0;
        dArray2[0][2] = -Math.sin(d);
        dArray2[1][0] = 0.0;
        dArray2[1][1] = 1.0;
        dArray2[1][2] = 0.0;
        dArray2[2][0] = -dArray2[0][2];
        dArray2[2][1] = 0.0;
        dArray2[2][2] = dArray2[0][0];
        this.pv.matrix_matrix_mult(this.mt, dArray2, dArray);
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                this.mt[n][n2] = dArray[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    void TiltCubeFace(double d) {
        double[][] dArray = new double[3][3];
        double[][] dArray2 = new double[3][3];
        dArray[0][0] = 1.0;
        dArray[0][1] = 0.0;
        dArray[0][2] = 0.0;
        dArray[1][0] = 0.0;
        dArray[1][1] = Math.cos(d);
        dArray[1][2] = Math.sin(d);
        dArray[2][0] = 0.0;
        dArray[2][1] = -dArray[1][2];
        dArray[2][2] = dArray[1][1];
        this.pv.matrix_matrix_mult(this.mt, dArray, dArray2);
        int n = 0;
        while (n < 3) {
            int n2 = 0;
            while (n2 < 3) {
                this.mt[n][n2] = dArray2[n][n2];
                ++n2;
            }
            ++n;
        }
    }
}

