/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ptmviewer
extends Applet {
    String PTViewer = "ptviewer";
    ptviewer pv = null;
    String filename = "image";
    String order = null;
    int[] y_LU = null;
    int[] w0 = null;
    int[] w1 = null;
    boolean hasCube = false;
    boolean hasPano = false;
    boolean hasHotspots = false;
    boolean hasJpeg = false;
    boolean hasTiff = false;
    boolean antialias = false;
    double max_oversampling = 1.5;
    static final int UNSIGNED = 1;
    static final int SIGNED = 2;
    static final int FLOATING_POINT = 3;
    static final int SHORT = 3;
    static final int LONG = 4;
    public static final int IMAGE_WIDTH = 256;
    public static final int IMAGE_LENGTH = 257;
    public static final int BITS_PER_SAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTO_INTERP = 262;
    public static final int STRIP_OFFSETS = 273;
    public static final int ROWS_PER_STRIP = 278;
    public static final int STRIP_BYTE_COUNT = 279;
    public static final int X_RESOLUTION = 282;
    public static final int Y_RESOLUTION = 283;
    public static final int RESOLUTION_UNIT = 296;
    public static final int COLOR_MAP = 320;
    public static final int SAMPLES_PER_PIXEL = 277;
    private boolean littleEndian;
    private int tiff_fp;
    private int tiff_start;
    private int tiff_width;
    private int tiff_height;
    private int tiff_rps;
    private int[] tiff_so;
    private int[] tiff_sbc;

    public ptmviewer() {
    }

    public ptmviewer(ptviewer ptviewer2, String string) {
        this.pv = ptviewer2;
        this.setStub(new ptstub(this.pv, string));
    }

    public void init() {
        String string = this.getParameter("file");
        if (string != null) {
            this.filename = string;
        }
        if ((string = this.getParameter("order")) != null) {
            this.order = string;
        }
        if ((string = this.getParameter("antialias")) != null) {
            this.antialias = true;
        }
        if ((string = this.getParameter("oversampling")) != null) {
            this.max_oversampling = Double.valueOf(string);
        }
    }

    public void start() {
        if (this.pv != null) {
            this.loadQTVR();
        }
    }

    void loadQTVR() {
        byte[] byArray = null;
        this.pv.percent[0] = 0;
        this.pv.repaint();
        byArray = this.pv.file_read(this.filename, this.pv.percent);
        if (byArray == null) {
            this.pv.fatal = true;
            return;
        }
        if (!this.check_qtvr(byArray)) {
            System.out.println("This doesn't seem to be a Quicktime VR-file");
            this.pv.fatal = true;
            return;
        }
        if (!this.hasJpeg) {
            System.out.println("Images in QTVR-file must use Photo-JPEG format.");
            this.pv.fatal = true;
            return;
        }
        this.set_qtvr_properties(this.get_qtvr_properties(byArray));
        if (this.hasPano) {
            if (this.hasCube) {
                this.pv.show_pdata = false;
                this.displayCubicQTVR(byArray);
            } else {
                this.displayCylindricalQTVR(byArray);
            }
        } else {
            this.pv.show_pdata = false;
            this.displayObjectQTVR(byArray);
        }
    }

    void displayObjectQTVR(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        Image[] imageArray = this.get_jpeg_images(byArray);
        if (imageArray == null || imageArray.length == 0) {
            System.out.println("Could not read QTVR-file.");
            this.pv.fatal = true;
            return;
        }
        String string = "{code=ptobject.class}{nhor=" + imageArray.length + "}";
        ptobject ptobject2 = new ptobject(this.pv, imageArray, string);
        this.pv.app_properties.addElement(string);
        this.pv.applets.put(string, ptobject2);
        ptobject2.init();
        ptobject2.start();
    }

    void displayCylindricalQTVR(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        Image[] imageArray = this.get_jpeg_images(byArray);
        if (imageArray == null || imageArray.length == 0) {
            System.out.println("Could not read QTVR-file.");
            this.pv.fatal = true;
            return;
        }
        int n = imageArray[0].getHeight(null) * imageArray.length;
        int n2 = imageArray[0].getWidth(null);
        int n3 = (int)((double)n / Math.PI * Math.atan((double)n2 / (double)n * Math.PI) + 0.5);
        int[][] nArray = null;
        try {
            nArray = new int[n3][n];
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nArray == null) {
            System.out.println("Not enough memory to load panorama");
            this.pv.fatal = true;
            return;
        }
        int[] nArray2 = new int[imageArray[0].getHeight(null) * n2];
        Object object = new byte[imageArray.length][];
        int n4 = 0;
        while (n4 < imageArray.length) {
            object[n4] = null;
            ++n4;
        }
        if (this.hasHotspots && this.hasTiff) {
            object = this.get_tiff_hsimages(byArray, imageArray.length);
        }
        int n5 = 0;
        while (n5 < imageArray.length) {
            this.pv.percent[0] = 80 + (n5 + 1) * 20 / imageArray.length;
            this.pv.repaint();
            Image image = imageArray[n5];
            PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, image.getWidth(null), image.getHeight(null), nArray2, 0, image.getWidth(null));
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            this.insert_cyltile(n5, nArray2, n2, nArray, object[n5]);
            ++n5;
        }
        this.y_LU = null;
        this.w0 = null;
        this.w1 = null;
        this.pv.pdata = new ImageData(nArray, this.pv);
    }

    void insert_cyltile(int n, int[] nArray, int n2, int[][] nArray2, byte[] byArray) {
        int n3;
        int n4;
        int n5;
        if (nArray == null || nArray2 == null) {
            return;
        }
        int n6 = nArray2.length;
        int n7 = nArray2[0].length;
        int n8 = nArray.length / n2;
        if (this.y_LU == null) {
            this.y_LU = new int[n6];
            this.w0 = new int[n6];
            this.w1 = new int[n6];
            double d = (double)n7 / (Math.PI * 2);
            double d2 = d * 256.0;
            double d3 = (double)n6 / 2.0 + 0.5;
            n5 = n2 * 128;
            n4 = 0;
            while (n4 < n6) {
                n3 = (int)(d2 * Math.tan(((double)n4 - d3) / d)) + n5;
                this.w1[n4] = n3 & 0xFF;
                this.w0[n4] = 255 - this.w1[n4];
                this.y_LU[n4] = n3 >> 8;
                if (this.y_LU[n4] < 0) {
                    this.y_LU[n4] = 0;
                }
                if (this.y_LU[n4] >= n2 - 1) {
                    this.y_LU[n4] = n2 - 2;
                }
                ++n4;
            }
        }
        int n9 = n7 - 1 - n * n8;
        int n10 = 0;
        while (n10 < n6) {
            int n11 = 0;
            int n12 = 0;
            while (n11 < n8) {
                int n13;
                int n14;
                int n15 = n12 + this.y_LU[n10];
                int n16 = nArray[n15];
                n5 = nArray[n15 + 1];
                n4 = byArray == null ? 0 : byArray[n15] << 24;
                n3 = (n16 >> 16 & 0xFF) * this.w0[n10] + (n5 >> 16 & 0xFF) * this.w1[n10] >> 8;
                if (n3 > 255) {
                    n3 = 255;
                }
                if (n3 < 0) {
                    n3 = 0;
                }
                if ((n14 = (n16 >> 8 & 0xFF) * this.w0[n10] + (n5 >> 8 & 0xFF) * this.w1[n10] >> 8) > 255) {
                    n14 = 255;
                }
                if (n14 < 0) {
                    n14 = 0;
                }
                if ((n13 = (n16 & 0xFF) * this.w0[n10] + (n5 & 0xFF) * this.w1[n10] >> 8) > 255) {
                    n13 = 255;
                }
                if (n13 < 0) {
                    n13 = 0;
                }
                nArray2[n10][n9 - n11] = n4 + (n3 << 16) + (n14 << 8) + n13;
                ++n11;
                n12 += n2;
            }
            ++n10;
        }
    }

    void displayCubicQTVR(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        Image[] imageArray = this.get_jpeg_images(byArray);
        if (imageArray == null || imageArray.length != 6) {
            System.out.println("Could not read QTVR-file.");
            this.pv.fatal = true;
            return;
        }
        String[] stringArray = new String[6];
        int n = 0;
        while (n < 6) {
            stringArray[n] = "{code=ptzoom.class}{fov=90.2}";
            ++n;
        }
        stringArray[0] = stringArray[0] + "{pan=180}";
        stringArray[1] = stringArray[1] + "{pan=-90}";
        stringArray[2] = stringArray[2] + "{pan=0}";
        stringArray[3] = stringArray[3] + "{pan=90}";
        stringArray[4] = stringArray[4] + "{pan=180}{tilt=90}";
        stringArray[5] = stringArray[5] + "{pan=180}{tilt=-90}";
        if (this.antialias) {
            int n2 = 0;
            while (n2 < 6) {
                int n3 = n2++;
                stringArray[n3] = stringArray[n3] + "{antialias=true}{oversampling=" + this.max_oversampling + "}";
            }
        }
        Object object = new byte[6][];
        int n4 = 0;
        while (n4 < 6) {
            object[n4] = null;
            ++n4;
        }
        if (this.hasHotspots && this.hasTiff) {
            object = this.get_tiff_hsimages(byArray, 6);
        }
        int n5 = 0;
        while (n5 < 6) {
            this.pv.percent[0] = 80 + n5 * 4;
            this.pv.repaint();
            ptzoom ptzoom2 = new ptzoom(this.pv, imageArray[n5], object[n5], stringArray[n5]);
            object[n5] = null;
            this.pv.app_properties.addElement(stringArray[n5]);
            this.pv.applets.put(stringArray[n5], ptzoom2);
            ptzoom2.init();
            ptzoom2.start();
            ++n5;
        }
    }

    Properties get_qtvr_properties(byte[] byArray) {
        Properties properties = new Properties();
        byte[] byArray2 = new byte[]{112, 108, 117, 103};
        int n = byArray.length - byArray2.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] == byArray2[0] && byArray[n2 + 1] == byArray2[1] && byArray[n2 + 2] == byArray2[2] && byArray[n2 + 3] == byArray2[3]) {
                int n3 = n2 += 4;
                while (n3 < byArray.length && byArray[n3] != 0) {
                    ++n3;
                }
                if (n3 > n2) {
                    byte[] byArray3 = new byte[n3 - n2];
                    System.arraycopy(byArray, n2, byArray3, 0, n3 - n2);
                    String string = new String(byArray3);
                    int n4 = string.indexOf(61);
                    if (n4 > 0 && n4 < string.length() - 1) {
                        ((Hashtable)properties).put(string.substring(0, n4).toLowerCase(), string.substring(n4 + 1));
                    }
                    byArray3 = null;
                    string = null;
                }
            }
            ++n2;
        }
        return properties;
    }

    Image[] get_jpeg_images(byte[] byArray) {
        Object object;
        int n;
        int n2;
        byte[] byArray2 = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70, 73, 70, 0};
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = byArray.length - byArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            if (byArray[n4] == byArray2[0] && byArray[n4 + 1] == byArray2[1] && byArray[n4 + 2] == byArray2[2] && byArray[n4 + 3] == byArray2[3] && byArray[n4 + 4] == byArray2[4] && byArray[n4 + 5] == byArray2[5] && byArray[n4 + 6] == byArray2[6] && byArray[n4 + 7] == byArray2[7] && byArray[n4 + 8] == byArray2[8] && byArray[n4 + 9] == byArray2[9] && byArray[n4 + 10] == byArray2[10]) {
                vector.addElement(new Integer(n4));
            }
            ++n4;
        }
        if (vector.size() == 0) {
            return null;
        }
        Vector<Integer> vector2 = new Vector<Integer>();
        int n5 = 0;
        while (n5 < vector.size()) {
            int n6 = (Integer)vector.elementAt(n5) + byArray2.length;
            n2 = n5 < vector.size() - 1 ? (Integer)vector.elementAt(n5 + 1) - 2 : byArray.length - 2;
            n4 = n6;
            while (n4 <= n2) {
                if (byArray[n4] == -1 && byArray[n4 + 1] == -39) {
                    vector2.addElement(new Integer(n4 + 2));
                    break;
                }
                ++n4;
            }
            if (vector2.size() != n5 + 1) {
                System.out.println("Could not read QTVR file");
                return null;
            }
            ++n5;
        }
        Vector<Image> vector3 = new Vector<Image>();
        n4 = 0;
        while (n4 < vector.size()) {
            n2 = (Integer)vector.elementAt(n4);
            n = (Integer)vector2.elementAt(n4);
            n3 = n - n2;
            object = new byte[n3];
            System.arraycopy(byArray, n2, object, 0, n3);
            vector3.addElement(this.pv.bufferToImage((byte[])object));
            ++n4;
        }
        n2 = 0;
        n4 = 0;
        while (n4 < vector3.size()) {
            object = (Image)vector3.elementAt(n4);
            n = object.getWidth(null) * object.getHeight(null);
            if (n > n2) {
                n2 = n;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < vector3.size()) {
            object = (Image)vector3.elementAt(n4);
            n = object.getWidth(null) * object.getHeight(null);
            if (n < n2) {
                vector3.removeElementAt(n4--);
            }
            ++n4;
        }
        if (this.order != null) {
            this.ordertiles(vector3, this.order);
        }
        object = new Image[vector3.size()];
        vector3.copyInto((Object[])object);
        return object;
    }

    void ordertiles(Vector vector, String string) {
        Vector vector2 = (Vector)vector.clone();
        if (this.pv == null) {
            return;
        }
        int n = 0;
        while (n < vector2.size()) {
            String string2 = this.pv.getArg(n, string);
            if (string2 != null) {
                vector.setElementAt(vector2.elementAt(Integer.parseInt(string2)), n);
            }
            ++n;
        }
    }

    byte[][] get_tiff_hsimages(byte[] byArray, int n) {
        byte[][] byArrayArray = new byte[n][];
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            byArrayArray[n3] = null;
            ++n3;
        }
        int n4 = 0;
        while (n4 < byArray.length) {
            int n5 = this.readtiffHeader(byArray, n4);
            if (n5 > 0) {
                if (this.readtiffdirectory(byArray, n4 + n5)) {
                    byArrayArray[n2] = this.readtiffdata(byArray);
                    if (byArrayArray[n2] != null) {
                        ++n2;
                    }
                    if (n2 >= n) break;
                }
                n4 += n5;
            }
            ++n4;
        }
        return byArrayArray;
    }

    final int getInt(byte[] byArray) throws IndexOutOfBoundsException {
        int n = byArray[this.tiff_fp++] & 0xFF;
        int n2 = byArray[this.tiff_fp++] & 0xFF;
        int n3 = byArray[this.tiff_fp++] & 0xFF;
        int n4 = byArray[this.tiff_fp++] & 0xFF;
        if (this.littleEndian) {
            return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    final int getShort(byte[] byArray) throws IndexOutOfBoundsException {
        int n = byArray[this.tiff_fp++] & 0xFF;
        int n2 = byArray[this.tiff_fp++] & 0xFF;
        if (this.littleEndian) {
            return (n2 << 8) + n;
        }
        return (n << 8) + n2;
    }

    int getValue(int n, int n2, byte[] byArray) throws IndexOutOfBoundsException {
        int n3 = 0;
        if (n == 3 && n2 == 1) {
            n3 = this.getShort(byArray);
            int n4 = this.getShort(byArray);
        } else {
            n3 = this.getInt(byArray);
        }
        return n3;
    }

    int readtiffHeader(byte[] byArray, int n) {
        this.tiff_fp = this.tiff_start = n;
        int n2 = -1;
        try {
            int n3 = this.getShort(byArray);
            if (n3 == 18761) {
                this.littleEndian = true;
            } else if (n3 == 19789) {
                this.littleEndian = false;
            } else {
                return -1;
            }
            int n4 = this.getShort(byArray);
            if (n4 != 42) {
                return -1;
            }
            n2 = this.getInt(byArray);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return -1;
        }
        this.tiff_width = 0;
        this.tiff_height = 0;
        this.tiff_rps = 0;
        this.tiff_so = null;
        this.tiff_sbc = null;
        return n2;
    }

    boolean readtiffdirectory(byte[] byArray, int n) {
        this.tiff_fp = n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        try {
            n6 = this.getShort(byArray);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        if (n6 < 1) {
            return false;
        }
        int n7 = 0;
        while (n7 < n6) {
            try {
                n2 = this.getShort(byArray);
                n3 = this.getShort(byArray);
                n4 = this.getInt(byArray);
                n5 = this.getValue(n3, n4, byArray);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return false;
            }
            switch (n2) {
                case 256: {
                    this.tiff_width = n5;
                    break;
                }
                case 257: {
                    this.tiff_height = n5;
                    break;
                }
                case 278: {
                    this.tiff_rps = n5;
                    break;
                }
                case 279: {
                    this.tiff_sbc = new int[n4];
                    if (n4 == 1) {
                        this.tiff_sbc[0] = n5;
                        break;
                    }
                    int n8 = this.tiff_fp;
                    this.tiff_fp = this.tiff_start + n5;
                    int n9 = 0;
                    while (n9 < n4) {
                        try {
                            this.tiff_sbc[n9] = this.getInt(byArray);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            return false;
                        }
                        ++n9;
                    }
                    this.tiff_fp = n8;
                    break;
                }
                case 273: {
                    this.tiff_so = new int[n4];
                    if (n4 == 1) {
                        this.tiff_so[0] = n5;
                        break;
                    }
                    int n8 = this.tiff_fp;
                    this.tiff_fp = this.tiff_start + n5;
                    int n9 = 0;
                    while (n9 < n4) {
                        try {
                            this.tiff_so[n9] = this.getInt(byArray);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            return false;
                        }
                        ++n9;
                    }
                    this.tiff_fp = n8;
                    break;
                }
                case 258: {
                    if (n5 == 8) break;
                    return false;
                }
                case 277: {
                    break;
                }
                case 259: {
                    if (n5 == 32773) break;
                    return false;
                }
                case 320: {
                    break;
                }
            }
            ++n7;
        }
        return this.tiff_width > 0 && this.tiff_height > 0 && this.tiff_rps > 0 && this.tiff_so != null && this.tiff_sbc != null && this.tiff_so.length == this.tiff_sbc.length;
    }

    byte[] readtiffdata(byte[] byArray) {
        byte[] byArray2 = new byte[this.tiff_width * this.tiff_height];
        int n = this.tiff_rps * this.tiff_width;
        int n2 = 0;
        while (n2 < this.tiff_so.length) {
            int n3;
            int n4 = n2 * n;
            if (n4 >= byArray2.length) {
                return null;
            }
            int n5 = n4 + n;
            if (n5 > byArray2.length) {
                n5 = byArray2.length;
            }
            if ((n3 = this.tiff_start + this.tiff_so[n2]) >= byArray.length) {
                return null;
            }
            int n6 = n3 + this.tiff_sbc[n2];
            if (n6 > byArray.length) {
                return null;
            }
            if (!this.unpackstripe(byArray, n3, n6, byArray2, n4, n5)) {
                System.out.println("Error unpacking strip " + n2);
                return null;
            }
            ++n2;
        }
        this.tiff_so = null;
        this.tiff_sbc = null;
        return byArray2;
    }

    /*
     * Unable to fully structure code
     */
    boolean unpackstripe(byte[] var1_1, int var2_2, int var3_3, byte[] var4_4, int var5_5, int var6_6) {
        while (var5_5 < var6_6) {
            block6: {
                if (var2_2 >= var3_3) {
                    return false;
                }
                if ((var7_7 = var1_1[var2_2++]) < 0) break block6;
                var8_8 = var2_2 + var7_7 + 1;
                if (var8_8 <= var3_3 && var5_5 + var7_7 + 1 <= var6_6) ** GOTO lbl9
                return false;
lbl-1000:
                // 1 sources

                {
                    var4_4[var5_5++] = var1_1[var2_2++];
lbl9:
                    // 2 sources

                    ** while (var2_2 < var8_8)
                }
lbl10:
                // 1 sources

                continue;
            }
            if (var7_7 == -128) continue;
            var8_8 = var5_5 - var7_7 + 1;
            if (var8_8 > var6_6) {
                return false;
            }
            if (var2_2 >= var3_3) {
                return false;
            }
            var7_7 = var1_1[var2_2++];
            while (var5_5 < var8_8) {
                var4_4[var5_5++] = var7_7;
            }
        }
        return true;
    }

    void set_qtvr_properties(Properties properties) {
        String string = null;
        if (properties == null || this.pv == null) {
            return;
        }
        double d = 480.0;
        double d2 = 336.0;
        double d3 = 0.0;
        this.pv.yaw = 180.0 - this.pv.yaw;
        string = properties.getProperty("width");
        if (string != null) {
            d = Double.valueOf(string);
        }
        if ((string = properties.getProperty("height")) != null) {
            d2 = Double.valueOf(string);
        }
        if ((string = properties.getProperty("fov")) != null) {
            double d4 = Double.valueOf(string);
            this.pv.hfov = 114.59155902616465 * Math.atan(d / d2 * Math.tan(d4 * Math.PI / 360.0));
        }
        if ((string = properties.getProperty("pan")) != null) {
            this.pv.yaw = 180.0 - Double.valueOf(string);
        }
        if ((string = properties.getProperty("tilt")) != null) {
            this.pv.pitch = Double.valueOf(string);
        }
        int n = 0;
        while (n <= this.pv.hotspots.size()) {
            string = properties.getProperty("hotspot" + (n + 1));
            if (string != null && n >= this.pv.hotspots.size()) {
                String string2 = properties.getProperty("target" + (n + 1));
                if (string2 != null) {
                    if (string2.equalsIgnoreCase("myself")) {
                        this.pv.hotspots.addElement("x" + n + " u'ptviewer:newPano({file=" + string + "})'");
                    } else {
                        this.pv.hotspots.addElement("x" + n + " u'" + string + "' t'" + string2 + "'");
                    }
                } else {
                    this.pv.hotspots.addElement("x" + n + " u'" + string + "'");
                }
            }
            ++n;
        }
    }

    boolean check_qtvr(byte[] byArray) {
        byte[] byArray2 = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70, 73, 70, 0};
        boolean bl = true;
        int n = byArray.length - byArray2.length;
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] == byArray2[0] && byArray[n2 + 1] == byArray2[1] && byArray[n2 + 2] == byArray2[2] && byArray[n2 + 3] == byArray2[3] && byArray[n2 + 4] == byArray2[4] && byArray[n2 + 5] == byArray2[5] && byArray[n2 + 6] == byArray2[6] && byArray[n2 + 7] == byArray2[7] && byArray[n2 + 8] == byArray2[8] && byArray[n2 + 9] == byArray2[9] && byArray[n2 + 10] == byArray2[10]) {
                return bl;
            }
            if (byArray[n2] == 99 && byArray[n2 + 1] == 117 && byArray[n2 + 2] == 98 && byArray[n2 + 3] == 101) {
                this.hasCube = true;
            } else if (byArray[n2] == 104 && byArray[n2 + 1] == 111 && byArray[n2 + 2] == 116 && byArray[n2 + 3] == 116) {
                this.hasHotspots = true;
            } else if (byArray[n2] == 112 && byArray[n2 + 1] == 97 && byArray[n2 + 2] == 110 && byArray[n2 + 3] == 111) {
                this.hasPano = true;
            } else if (byArray[n2] == 106 && byArray[n2 + 1] == 112 && byArray[n2 + 2] == 101 && byArray[n2 + 3] == 103) {
                this.hasJpeg = true;
            } else if (byArray[n2] == 116 && byArray[n2 + 1] == 105 && byArray[n2 + 2] == 102 && byArray[n2 + 3] == 102) {
                this.hasTiff = true;
            }
            ++n2;
        }
        return bl;
    }
}

